%[l,a,lambda,jcr,sigma]
% par0 = [0.02   1.71   .15   0.055   1];
% 
% %[R,T,S,v,theta]
% R0 = [ -.56 ; -.74 ; -.92 ];
% T0 = [ -.41 ; -.43 ; -.44 ];
% S0 = [ -.33 ; -.33 ; -.33 ];
% v0 = [ .059 ; .092 ; .116 ];
% theta0 = [ .26 ; .47 ; .68 ];
% 
% var0 = [R0,T0,S0,v0,theta0];
% 
% %[c,beta,r,b,k,nu]
% otherpar0 = [0.465  0.5     0.01    0.8     0.1     1];
% 
% %[xsi,alpha]
% parmatch0 = [0.6    0.5];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%[xsi,alpha]
parmatch0 = [1.1    0.5];

%[a,lambda,jcr,sigma]
par0 = [ 1.71   .25   0.055   1];

%[c,beta,r,b,k]
otherpar0 = [0.465  0.5     0.01    0.9     0.1  ];

par0 = [par0 otherpar0];

% changes to previous parameters
% par0(5)=.75;
% par0(2)=.1;


%[R,T,S,v,theta]
R0 = [ -.56 ; -.74 ; -.92 ];
T0 = [ -.41 ; -.43 ; -.44 ];
S0 = [ -.33 ; -.33 ; -.33 ];
v0 = [ .059 ; .092 ; .116 ];
theta0 = [ .26 ; .47 ; .68 ];

%--------------------------------------
%  setting of P vector
%--------------------------------------
chi1 = .022;
P = [exp(chi1) ; 1 ; exp(-chi1) ] ;


var0 = [R0,T0,S0,v0,theta0];

var1 = modeleq(par0,parmatch0,var0)

[R1,T1,S1,v1,theta1]=expandvar(var1);

zero=zeros(3,3);
for p=1:3
zerop = [ M(R1(p),par0,parmatch0,var1) ...
V(T1(p),par0,parmatch0,var1) ...
M(S1(p)-.0001,par0,parmatch0,var1) - M(S1(p)+.0001,par0,parmatch0,var1) ];
zero(p)=zerop(p);
end;
zero

%model outcomes
% u     v     v/u   theta  u/j  exitrate inflrate  meanw
lambda0=par0(2);
a0=par0(1);
vu=var1(:,4)./u(par0,parmatch0,var1);
uoj=u(par0,parmatch0,var1)./ojres(par0,parmatch0,var1);
exitrate = theta1.*q(theta1,parmatch0);
inrate = lambda0*Fcdf(R1,par0);
meanw = iwFE(par0,parmatch0,var1);


res=[u(par0,parmatch0,var1) v1 vu theta1 uoj exitrate inrate meanw]

%relative volatilities of model outcomes
relvol=zeros(2,8);

for i=1:8;
    relvol(1,i)=log(res(1,i)/res(2,i))/log(P(1)/P(2));
    relvol(2,i)=log(res(2,i)/res(3,i))/log(P(2)/P(3));
 end;
 relvol
 
%flows
JF=lambda0*Fcdf(R1,par0).*(1-u(par0,parmatch0,var1));
JJF=a0*theta1.*q(theta1,parmatch0).*ojres(par0,parmatch0,var1);
UF=exitrate.*u(par0,parmatch0,var1);
WF=UF+JJF;
JFWF=JF./WF;
UFJF=UF./JF;

flows = [JF JJF UF WF JFWF UFJF];

%fraction of job movers experiencing wage drops

frac = (FES(par0,parmatch0,var1)-FET(par0,parmatch0,var1)) .* ...
            FVTS(S1,par0,parmatch0,var1) ./ FES(par0,parmatch0,var1) /2
        
